<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\Controller;
use App\Libraries\Tabler;
use App\Models\Appointment;
use App\Models\Patient;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Dashboard extends Controller
{
    public function index(Request $request)
    {

        if (is_admin()) {

            $this->receptionDashboard($request);

        } else {

            $role = user_role();

            if ($role) {

                switch ($role->dashboard) {
                    case 0: //default
                        //$this->defaultDashboard();
                        $this->receptionDashboard($request);
                        break;
                    case 1: //physician
                        $this->physicianDashboard($request);
                        break;
                    case 2: //reception
                        $this->receptionDashboard($request);
                        break;
                    case 3: //manager
                        $this->managerDashboard();
                        break;
                    default:
                        $this->defaultDashboard();
                        break;
                }
            }else{
                $this->receptionDashboard($request);
            }
        }
    }
    //------------------------------------------------------------------------------------

    /**
     * Loads default dashboard
     *
     * @return void
     */
    private function defaultDashboard()
    {

    }
    //------------------------------------------------------------------------------------
    /**
     * Load super admin dashboard
     *
     * @return void
     */
    private function adminDashboard()
    {

    }
    //------------------------------------------------------------------------------------
    /**
     * Load physician dashboard
     *
     * @return void
     */
    private function physicianDashboard(Request $request)
    {

        $model = new Appointment();

        $model = $model->allowedPatients();

        $confirmed = __('admin/common.status.confirmed');
        $not_confirmed = __('admin/common.status.not_confirmed');

        $status = DB::raw("IF(is_confirmed = 1,'" . $confirmed . "', '" . $not_confirmed . "') AS status");

        $select = [
            'ref_number','appointments.id as id','start_time','treatments.treatment AS treatment',
            $model->patientFullName(),'patients.mobile AS patient_mobile',$status
        ];

        //$select = $model->appointmentsListColumns();

        $model = $model->join('treatments', 'appointments.treatment_id', '=', 'treatments.id');

        $model = $model->join('patients', 'appointments.patient_id', '=', 'patients.id');

        $model = $model->where('appointments.postponed', '=', 0);

        $model = $model->orderBy('appointment_date')->orderBy('start_time');

        $th = ['ref_number', 'patient_name', 'patient_mobile', 'treatment', 'start_time','status'];

        $sortable = ['ref_number', 'patient_name', 'patient_mobile', 'treatment', 'start_time','status'];

        $searchable = ['ref_number', 'patient_name', 'patient_mobile', 'treatment','status'];

        $table = new Tabler('admin.appointments', $model, $select, $th, $sortable, $searchable, $request, true);

        $data = $table->initTable();

        //$this->loadView('appointments.index', 'appointments.title', 'appointments', [], $data);

        $this->loadView('dashboard.reception','dashboard.title','dashboard',[],$data);

    }
    //------------------------------------------------------------------------------------
    /**
     * Load reception dashboard
     *
     * @return void
     */
    private function receptionDashboard(Request $request)
    {

        $today = date('Y-m-d');

        $model = new Appointment();

        $patient = $model->patientFullName();

        $model = $model->allowedPatients();

        $confirmed = __('admin/common.status.confirmed');
        $not_confirmed = __('admin/common.status.not_confirmed');

        $status = DB::raw("IF(is_confirmed = 1,'" . $confirmed . "', '" . $not_confirmed . "') AS status");

        $select = [
            'ref_number','appointments.id as id','start_time','treatments.treatment AS treatment',
            $patient,'patients.mobile AS patient_mobile',$status
        ];

        $model = $model->join('treatments', 'appointments.treatment_id', '=', 'treatments.id');

        $model = $model->join('patients', 'appointments.patient_id', '=', 'patients.id');

        $model = $model->where('appointments.postponed', '=', 0);
        
        //$model = $model->where('appointments.appointment_date', '=', $today);

        $model = $model->orderBy('start_time');

        $th = ['ref_number', 'appointment_date', 'patient_name', 'patient_mobile', 'treatment', 'branch', 'start_time'];

        $sortable = ['ref_number', 'appointment_date', 'patient_name', 'patient_mobile', 'treatment', 'branch', 'start_time'];

        $searchable = ['ref_number', 'appointment_date', 'patient_name', 'patient_mobile', 'treatment', 'branch'];

        //$table = new Tabler('admin.appointments', $model, $select, $th, $sortable, $searchable, $request, true);

        //$data = $table->initTable();
        $data['appointments'] = $model->select($select)->get();


        $data['patients_in_reception'] = $this->patientsInReception();

        $css = ['bs-select/bootstrap-select.min.css','ajax-bs-select/ajax-bootstrap-select.min.css'];
        $js = ['bs-select/bootstrap-select.min.js','ajax-bs-select/ajax-bootstrap-select.min.js'];
        
        $this->loadView('dashboard.reception','dashboard.title','dashboard',[],$data,$css,$js);
    
    }
    //------------------------------------------------------------------------------------
    /**
     * Get Available physicians
     *
     * @param Request $request
     * @return void
     */
    public function getAvailablePhysicians(Request $request){

        if ( $request->ajax() ) {

            $reserved_physicians = DB::table('appointment_user')->where(['admission_date' => '2022-01-20','checkout_time' => null])->pluck('user_id');

            $available_users = User::where('role_id',1)->whereNotIn('id',$reserved_physicians)->orderBy('first_name')->get();
    
            return response()->json(['users' => $available_users],200);    

        }
    }
    //-----------------------------------------------------------------------------------
    public function getBusyPhysicians(Request $request){

        //if ( $request->ajax() ) {

            $reserved_physicians = DB::table('appointment_user')->where(['admission_date' => '2022-01-21','checkout_time' => null])->pluck('user_id');

            $busy_physicians = User::where('role_id',1)->whereIn('id',$reserved_physicians)->orderBy('first_name')->get();
    
            return response()->json(['users' => $busy_physicians],200);    

        //}
    }
    //------------------------------------------------------------------------------------
    /**
     * Get patients without appointments on that day
     *
     * @param Request $request
     * @return void
     */
    public function getNoAppPatients(Request $request){


        $search_query = $request->input('sq');
        
        $today = date('Y-m-d');

        $patients_with_appointments = Appointment::where(['appointment_date' => $today,'checked_in_at' => null])->pluck('patient_id');

        $patients = Patient::whereNotIn('id',$patients_with_appointments)->where('mobile','like','%' . $search_query . '%')->get();

        return response()->json(['patients' => $patients]);

    }
    //------------------------------------------------------------------------------------
    /**
     * Load reception dashboard
     *
     * @return void
     */
    private function managerDashboard()
    {
        
    }

    private function patientsInReception(){

        $model = new Appointment();

        $select = [$model->patientFullName(),'patient_id','appointments.id as appointment_id',DB::raw('DATE_FORMAT(`start_time`, "%h:%i %p") as start_time'),];

        $model = $model->select($select);

        $model = $model->join('patients', 'patients.id', '=', 'appointments.patient_id');

        $model = $model->whereNotNull('appointments.checked_in_at');

        return $model->get();
    }
}
